<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Product;
use Faker\Generator as Faker;

$factory->define(Product::class, function (Faker $faker) {
    static $product_id = 1;
    $product_type = [
        1 => 'Phone',
        2 => 'Balalaika'
    ];

    return [
        'reference' => 'Product ' . $product_id++,
        'description_short' => $faker->sentence,
        'description_long' => $faker->paragraph,
        'price' => $faker->randomNumber(4),
        'type' => $product_type[rand(1, 2)],
    ];
});
