@extends('layouts.app')

@section('content')
    <section class="cart">
        <div class="container">

            @if(Session::has('cart'))
                <div class="modal fade" id="clearCartModal"  tabindex="-1" role="dialog" aria-labelledby="clearCartModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document" style="margin-top: 150px;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="clearCartModalLabel">Are you sure you want to delete all items from cart?</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body d-flex justify-content-between">
                                <form action="{{ route('cart.clearCart') }}" method="POST">
                                    @csrf
                                    <button class="btn btn-danger">Clear cart</button>
                                </form>
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="placeOrderModal"  tabindex="-1" role="dialog" aria-labelledby="placeOrderModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document" style="margin-top: 150px;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="placeOrderModalLabel">Are you sure you want to place the order?</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body d-flex justify-content-between">
                                <form action="{{ route('order.sendOrder') }}" method="POST">
                                    @csrf
                                    <button class="btn btn-success">Send order</button>
                                </form>
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

                <table id="cart" class="table table-hover table-condensed">
                    <thead>
                    <tr>
                        <th style="width:50%">Product</th>
                        <th style="width:10%">Price</th>
                        <th style="width:10%">Quantity</th>
                        <th style="width:15%" class="text-center">Subtotal</th>
                        <th style="width:15%" class="text-right">
                            <button class="btn btn-danger btn-sm ml-auto"
                                    data-toggle="modal"
                                    data-target="#clearCartModal"
                            >Clear cart</button>
                        </th>
                    </tr>
                    </thead>

                    <tbody class="js-cart"
                           data-get-items-url="{{ route('cart.getItems') }}"
                           data-update-item-url="{{ route('cart.updateQtyInCart') }}"
                           data-remove-item-url="{{ route('cart.removeFromCart') }}"
                           data-item-url="{{ route('productPath') }}"
                    >
    {{--                    @foreach($products as $product)
                            <tr>
                                <td>
                                    <div class="row">
                                        <div class="col-sm-3 hidden-xs"><img src="/img/{{ $product['item']->type }}.jpg" width="100" height="100" alt="{{ $product['item']->reference }}" class="img-responsive"/></div>
                                        <div class="col-sm-9">
                                            <h4 class="nomargin"><a href="{{ $product['item']->path() }}">{{ $product['item']->reference }}</a></h4>
                                            <p>{{ $product['item']->description_short }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td>€ {{ $product['item']->price }}</td>
                                <td>
                                    <input type="number"
                                           min="0"
                                           class="js-qty-input form-control text-center"
                                           data-product_id="{{ $product['item']->id }}"
                                           value="{{ $product['qty'] }}">
                                </td>
                                <td class="text-center">€ {{ $product['item']->price * $product['qty'] }}</td>
                                <td class="actions text-right">
                                    <button class="js-remove-btn btn btn-danger btn-sm"
                                            data-action=" {{ route('cart.removeFromCart', $product['item']) }}"
                                    >Remove</button>
                                </td>
                            </tr>
                        @endforeach--}}
                    </tbody>

                    <tfoot>
                        <tr>
                            <td>
                                <a href="{{ route('homepage') }}" class="btn btn-primary"> Continue Shopping</a>
                            </td>
                            <td colspan="2" class="text-right">
{{--                                <button class="js-update-qty-btn btn btn-warning"--}}
{{--                                        data-action="{{ route('cart.updateQtyInCart') }}"--}}
{{--                                >Update quantity</button>--}}
                            </td>
                            <td class="hidden-xs text-center"><b class="js-total-cart-price"></b></td>
                            <td>
                                <button class="btn btn-success btn-block" data-toggle="modal" data-target="#placeOrderModal">
                                    Send order
                                </button>
                            </td>
                        </tr>
                    </tfoot>
                </table>

            @else
                @if( session('order_id') )
                    <div class="alert alert-success">Thank you, order succesfully placed. Your order number is <b>{{ session('order_id') }}</b>. We will contact you shortly.</div>
                    <a href="{{ route('homepage') }}">You may like our other products</a>
                @else
                    <div>There are no products in the cart. <a href="{{ route('homepage') }}">Check our products</a></div>
                @endif
            @endif

        </div>
    </section>
@endsection

@if(Session::has('cart'))
    @section('script')
        <script src="js/cart.js" defer></script>
    @endsection
@endif
