@extends('layouts.app')

@section('content')
    <section class="create-product">
        <div class="container">
            <h1>Create product</h1>
            <form method="POST" action="/product">
                @csrf

                <div class="form-group row">
                    <label for="reference" class="col-sm-2 col-form-label">Product reference</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="reference" name="reference" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="description_short" class="col-sm-2 col-form-label">Short description</label>
                    <div class="col-sm-10">
                        <textarea class="form-control" id="description_short" rows="3" name="description_short" required></textarea>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="description_long" class="col-sm-2 col-form-label">Long description</label>
                    <div class="col-sm-10">
                        <textarea class="form-control" id="description_long" rows="3" name="description_long" required></textarea>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="product-type" class="col-sm-2 col-form-label">Product type</label>
                    <div class="col-sm-10">
                        <select class="custom-select custom-select-sm" name="type" id="product-type" required>
                            <option selected></option>
                            <option value="Phone">Phone</option>
                            <option value="Balalaika">Balalaika</option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="price" class="col-sm-2 col-form-label">Price</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="price" name="price" required>
                    </div>
                </div>
                <button class="btn btn-primary">Submit</button>
            </form>
        </div>
    </section>
@endsection
