function setAddToCardEventListener() {
    document.querySelector('.js-btn-add-to-basket').addEventListener('click', function(e) {
        const actionUrl = this.dataset.action;

        axios.post(actionUrl)
            .then(function (response) {
                const cartAmountElem = document.querySelector('.amount-in-cart');
                cartAmountElem.textContent = response.data;
                toastr.success('Product added to cart');
            })
            .catch(function (error) {
                console.log(error);
                toastr.error('Error, something went wrong');
            });
    });
}

setAddToCardEventListener();
