@extends('layouts.app')

@section('content')
    <section class="create-product">
        <div class="container">
            <h1>Create product</h1>
            <form method="POST" action="/product">
                @csrf

                <div class="form-group row">
                    <label for="reference" class="col-sm-2 col-form-label">Product reference</label>

                    <div class="col-sm-10">
                        <input
                            type="text"
                            class="form-control @error('reference') is-invalid @enderror"
                            id="reference"
                            name="reference"
                            value="{{ old('reference') }}"
                        >

                        @error('reference')
                            <div class="invalid-feedback"> {{ $errors->first('reference') }}</div>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="description_short" class="col-sm-2 col-form-label">Short description</label>

                    <div class="col-sm-10">
                        <textarea
                            class="form-control @error('description_short') is-invalid @enderror"
                            id="description_short"
                            rows="3"
                            name="description_short"
                            required
                        >{{ old('description_short') }}</textarea>

                        @error('description_short')
                            <div class="invalid-feedback"> {{ $errors->first('description_short') }}</div>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="description_long" class="col-sm-2 col-form-label">Long description</label>

                    <div class="col-sm-10">
                        <textarea
                            class="form-control @error('description_long') is-invalid @enderror"
                            id="description_long"
                            rows="3"
                            name="description_long"
                            required
                        >{{ old('description_long') }}</textarea>

                        @error('description_long')
                            <div class="invalid-feedback"> {{ $errors->first('description_long') }}</div>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="product-type" class="col-sm-2 col-form-label">Product type</label>

                    <div class="col-sm-10">
                        <select
                            class="custom-select custom-select @error('type') is-invalid @enderror"
                            name="type"
                            id="product-type"
                            required
                        >
                            <option selected disabled></option>
                            <option
                                value="Phone"
                                {{ (old('type') === 'Phone') ? 'selected' : '' }}
                            >Phone</option>
                            <option
                                value="Balalaika"
                                {{ (old('type') === 'Balalaika') ? 'selected' : '' }}
                            >Balalaika</option>
                        </select>

                        @error('type')
                            <div class="invalid-feedback"> {{ $errors->first('type') }}</div>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="price" class="col-sm-2 col-form-label">Price</label>

                    <div class="col-sm-10">
                        <input
                            type="text"
                            class="form-control @error('price') is-invalid @enderror"
                            id="price"
                            name="price"
                            required
                            value="{{ old('price') }}"
                        >

                        @error('price')
                            <div class="invalid-feedback"> {{ $errors->first('price') }}</div>
                        @enderror
                    </div>
                </div>

                <button class="btn btn-primary">Submit</button>
            </form>
        </div>
    </section>
@endsection
