<?php

namespace App\Http\Controllers;

use App\Cart;
use Illuminate\Http\Request;
use App\Product;
use Session;


class CartController extends Controller
{
    public function index()
    {

        if (!Session::has('cart')) {
            return view('cart');
        }

        $cart = Session::get('cart');
        $products = $cart->items;

        return view('cart', compact('cart', 'products'));
    }

    public function addToCart(Product $product)
    {
        $product->addItemToCart();
    }

    public function updateQtyInCart(Request $request)
    {
        $products_qty = json_decode($request->productsQty, true);
        $cart = Session::get('cart');
        $cart->updateQty($products_qty);
    }
}
