function setUpdateCartQtyEventListener() {
    document.querySelector('.js-update-qty-btn').addEventListener('click', function(e) {

        const actionUrl = this.dataset.action;

        const qtyInputs = document.querySelectorAll('.js-qty-input');

        const productsQty = {};

        qtyInputs.forEach(item => {
           const productId = item.dataset.product_id;
            productsQty[productId] = item.value;
        });

        axios.post(actionUrl, {
            productsQty: JSON.stringify(productsQty)
        })
            .then(function (response) {
                document.location.reload(true);;
            })
            .catch(function (error) {
                console.log(error);
            });
    });
}

setUpdateCartQtyEventListener();
