<?php

namespace App\Http\Controllers;

use App\Jobs\SendOrderConfirmation;
use App\Mail\OrderConfirmation;
use App\Order;
use App\OrderDetail;
use App\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Session;

class OrderController extends Controller
{
    function store()
    {
        if (!Session::has('cart')) {
            return redirect('cart');
        }

        $cart = Session::get('cart');

        $order = Order::create([
            'user_id' => Auth::id(),
            'total_price' => $cart->total_price,
            'total_qty' => $cart->total_qty,
        ]);

        foreach ($cart->items as $id => $item) {
            $product = Product::where('id', $id)->first();

            OrderDetail::create([
                'order_id' => $order->id,
                'product_id' => $id,
                'ordered_reference' => $product->reference,
                'ordered_price' => $product->price,
                'ordered_qty' => $item['qty'],
                'subtotal_price' => $product->price * $item['qty'],
            ]);
        }

        Session::forget('cart');

////        $order->user->email
////        TODO to ask/check how to pass e-mail as variable to Mail::raw
//        Mail::raw('Order placed, hehe123.', function ($message) {
//            $message->to('ololo@info.com')
//                ->subject('Order subject');
//        });


        Mail::to($order->user->email)
            ->queue(new OrderConfirmation($order->id));

        return redirect('cart')->with('order_id', $order->id);
    }
}
