function setAddToCardEventListener() {
    document.querySelector('.products').addEventListener('click', function(e) {
        if (!e.target.classList.contains('js-btn-add-to-basket')) return;

        const actionUrl = e.target.dataset.action;

        axios.post(actionUrl)
            .then(function (response) {
                const cartAmountElem = document.querySelector('.amount-in-cart');
                cartAmountElem.textContent = response.data;
                toastr.success('Product added to cart');
            })
            .catch(function (error) {
                console.log(error);
                toastr.error('Error, something went wrong');
            });
    });
}

setAddToCardEventListener();
