@extends('layouts.app')

@section('content')
        <section class="product-info">
            <div class="container">
                <div>
                    <a {{--href="/product/{{ $product->id }}/edit"
                        href="{{ route('product.edit', $product) }}--}}
                       href="{{ $product->editPath() }}"
                    >Edit product</a>
                </div>
                <div>
                    <img src="/img/{{$product->type}}.jpg" alt="{{$product->reference}}">
                </div>
                <h2>{{$product->reference}}</h2>
                <p>{{$product->description_long}}</p>
                <p class="text-danger font-weight-bold">Price {{$product->price}} EUR</p>

                <button class="js-btn-add-to-basket btn btn-info text-white"
                        data-action="{{ route('cart.addToCart', $product) }}"
                >Add to basket</button>

{{--                <form method="POST" action="{{ $product->path() }}">--}}
{{--                    @csrf--}}
{{--                    @method('DELETE')--}}

{{--                    <button class="btn btn-outline-danger mt-5">Delete product</button>--}}
{{--                </form>--}}
            </div>
        </section>
@endsection

@section('script')
    <script src="/js/product.js" defer></script>
@endsection
