<?php

namespace App\Http\Controllers;

use App\Cart;
use Illuminate\Http\Request;
use App\Product;
use Session;


class CartController extends Controller
{
    public function index()
    {
        if (!Session::has('cart')) {
            return view('cart');
        }

        $cart = Session::get('cart');

//    need to take products from database because product data may change
        $cart->updateCurrentItems();

        return view('cart', compact('cart'));
    }

    public function addToCart(Product $product)
    {
        if (Session::has('cart')) {
            $cart = Session::get('cart');
            $cart->addItem($product->id);
        } else {
            $cart = new Cart();
            $cart->addItem($product->id);
            Session::put('cart', $cart);
        }

        return $cart->total_qty;
    }

    public function updateQtyInCart(Request $request)
    {
        if (!Session::has('cart')) {
            return route('homepage');
        }

        $cart = Session::get('cart');

        $cart->updateQty($request->productId, $request->changedQty);

        if (!$cart->total_qty) {
            Session::forget('cart');
            return route('homepage');
        }
    }

    public function removeFromCart(Request $request)
    {
        $cart = Session::get('cart');

        $cart->removeItem($request->productId);

        if (!$cart->total_qty) {
            Session::forget('cart');
            return route('homepage');
        }

        $cart->updateCurrentItems();
    }

    public function clearCart()
    {
        Session::forget('cart');
        return redirect(route('homepage'));
    }

    public function getItems()
    {
        $cart = Session::get('cart');

//      make array of products in order to get correct order of items in js
        $cart_products = [];
        foreach ($cart->items as $item) {
            $cart_products[] = $item;
        }

        $response = [
            'cart' => $cart,
            'products' => $cart_products,
            'update_item_url' => route('cart.updateQtyInCart'),
            'remove_item_url' => route('cart.removeFromCart'),
            'item_url' => '/product/'
        ];

        return json_encode($response);
    }
}
