<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Session;
use App\Cart;

class Product extends Model
{
    protected $fillable = ['reference', 'description_short', 'description_long', 'type', 'price'];
//    protected  $guarded = []; //remove protection against mass assignment

    public function path()
    {
        return route('product.show', $this); // this is $product
    }

    public function editPath()
    {
        return route('product.edit', $this);
    }

    public function addItemToCart()
    {
        if (Session::has('cart')) {
            $cart = Session::get('cart');
            $cart->addItem($this, $this->id);
        } else {
            $cart = new Cart();
            $cart->addItem($this, $this->id);
            Session::put('cart', $cart);
        }
    }
}
