function setAddToCardEventListener() {
    document.querySelector('.products').addEventListener('click', function(e) {
        if (!e.target.classList.contains('js-btn-add-to-basket')) return;
        e.preventDefault();

        const actionUrl = e.target.dataset.action;

        axios.post(actionUrl, {
            productId: e.target.dataset.product_id
        })
            .then(function (response) {
                const cartAmountElem = document.querySelector('.amount-in-cart');
                cartAmountElem.textContent++;
            })
            .catch(function (error) {
                console.log(error);
            });
    });
}

setAddToCardEventListener();
