<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'ProductController@index')->name('homepage');

Route::prefix('product')->group(function() {
    Route::post('/', 'ProductController@store');
    Route::get('/create', 'ProductController@create');
    Route::get('/{product}', 'ProductController@show')->name('product.show');
    Route::get('/{product}/edit', 'ProductController@edit')->name('product.edit');
    Route::put('/{product}', 'ProductController@update');
    Route::delete('/{product}', 'ProductController@destroy');
});


Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');


Route::get('/cart', 'CartController@index')->name('cart.index');
Route::post('/cart/add/{product}', 'CartController@addToCart')->name('cart.addToCart');
Route::post('/cart/update', 'CartController@updateQtyInCart')->name('cart.updateQtyInCart');
Route::post('/cart/remove/{product}', 'CartController@removeFromCart')->name('cart.removeFromCart');
Route::post('/cart/clear', 'CartController@clearCart')->name('cart.clearCart');
