<?php

namespace App\Http\Controllers;

use App\Cart;
use Illuminate\Http\Request;
use App\Product;
use Session;


class CartController extends Controller
{
    public function index()
    {
        if (!Session::has('cart')) {
            return view('cart');
        }

        $cart = Session::get('cart');
//    need to take products from database because product data may change
        $cart->updateCurrentItems();
        $products = $cart->items;

        return view('cart', compact('cart','products'));
    }

    public function addToCart(Product $product)
    {
        if (Session::has('cart')) {
            $cart = Session::get('cart');
            $cart->addItem($product->id);
        } else {
            $cart = new Cart();
            $cart->addItem($product->id);
            Session::put('cart', $cart);
        }

        return $cart->total_qty;

    }

    public function updateQtyInCart(Request $request)
    {
        $products_qty = json_decode($request->productsQty, true);
        $cart = Session::get('cart');
        $cart->updateQty($products_qty);

        if (!$cart->total_qty) {
            Session::forget('cart');
            return route('homepage');
        }
    }

    public function removeFromCart(Product $product)
    {
        $cart = Session::get('cart');

        $cart->removeItem($product->id);

        if (!$cart->total_qty) {
            Session::forget('cart');
            return route('homepage');
        }
    }

    public function clearCart()
    {
        Session::forget('cart');
        return redirect(route('homepage'));
    }
}
