<?php

namespace App;

//use Illuminate\Database\Eloquent\Model;
use App\Product;

class Cart /*extends Model*/
{
    public function __construct()
    {
        $this->items = [];
        $this->total_qty = 0;
        $this->total_price = 0;
    }

    public function updateTotalQty()
    {
        $result = 0;
        foreach ($this->items as $item)
        {
            $result += $item['qty'];
        }
        $this->total_qty = $result;
    }

    public function updateTotalPrice()
    {
        $result = 0;
        foreach ($this->items as $item)
        {
            $result += $item['qty'] * $item['item']->price;
        }
        $this->total_price = $result;
    }

    public function addItem($id)
    {
        if (array_key_exists($id, $this->items)) {
            $this->items[$id]['qty']++;
        } else {
            $this->items[$id] = [
                'qty' => 1
            ];
        }

        $this->total_qty++;
    }

    public function updateQty($products_qty)
    {
        foreach ($products_qty as $id => $qty) {
            if (!$qty) {
                $this->removeItem($id);
            } else {
                $this->items[$id]['qty'] = (int)$qty;
                $this->updateTotalQty();
            }
        }
    }

    public function removeItem($id)
    {
        unset($this->items[$id]);
        $this->updateTotalQty();
    }

    public function updateCurrentItems()
    {
        foreach ($this->items as $id => $item) {
            $this->items[$id]['item'] = Product::where('id', $id)->first();
        }
        $this->updateTotalPrice();
    }
}
