function setUpdateCartQtyEventListener() {
    document.querySelector('.js-update-qty-btn').addEventListener('click', function(e) {

        const actionUrl = this.dataset.action;

        const qtyInputs = document.querySelectorAll('.js-qty-input');

        const productsQty = {};

        qtyInputs.forEach(item => {
           const productId = item.dataset.product_id;
            productsQty[productId] = item.value;
        });

        axios.post(actionUrl, {
            productsQty: JSON.stringify(productsQty)
        })
            .then(function (response) {
                document.location.reload(true);
            })
            .catch(function (error) {
                console.log(error);
            });
    });
}

function setRemoveItemEventListener() {
    document.querySelector('.js-products-in-cart').addEventListener('click', function(e) {
        if (!e.target.classList.contains('js-remove-btn')) return;
        const actionUrl = e.target.dataset.action;

        axios.post(actionUrl)
            .then(function (response) {
                document.location.reload(true);
            })
            .catch(function (error) {
                console.log(error);
                alert('Sorry, error, we are just learning how to code');
            });
    });
}

function setClearCartEventListener() {
    document.querySelector('.js-clear-cart-btn').addEventListener('click', function (e) {
        const isSure = confirm('Are you sure you want to delete all items from cart?');
        if (!isSure) {
            e.preventDefault();
        }
    })
}

setUpdateCartQtyEventListener();
setRemoveItemEventListener();
setClearCartEventListener();
