@extends('layouts.app')

@section('content')
    <section class="cart">
        <div class="container">

            @if(Session::has('cart'))
                <table id="cart" class="table table-hover table-condensed">
                    <thead>
                    <tr>
                        <th style="width:50%">Product</th>
                        <th style="width:10%">Price</th>
                        <th style="width:10%">Quantity</th>
                        <th style="width:15%" class="text-center">Subtotal</th>
                        <th style="width:15%" class="text-right"><button class="btn btn-danger btn-sm ml-auto">Clear cart</button></th>
                    </tr>
                    </thead>

                    <tbody class="">
                        @foreach($products as $product)
                            <tr>
                                <td>
                                    <div class="row">
                                        <div class="col-sm-3 hidden-xs"><img src="/img/{{ $product['item']->type }}.jpg" width="100" height="100" alt="{{ $product['item']->reference }}" class="img-responsive"/></div>
                                        <div class="col-sm-9">
                                            <h4 class="nomargin"><a href="{{ $product['item']->path() }}">{{ $product['item']->reference }}</a></h4>
                                            <p>{{ $product['item']->description_short }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td>€ {{ $product['item']->price }}</td>
                                <td>
                                    <input type="number"
                                           class="js-qty-input form-control text-center"
                                           data-product_id="{{ $product['item']->id }}"
                                           value="{{ $product['qty'] }}">
                                </td>
                                <td class="text-center">€ {{ $product['item']->price * $product['qty'] }}</td>
                                <td class="actions text-right">
                                    <button class="btn btn-danger btn-sm">Remove</button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>
                        <tr>
                            <td>
                                <a href="{{ route('homepage') }}" class="btn btn-primary"> Continue Shopping</a>
                            </td>
                            <td colspan="2" class="text-right">
                                <button class="js-update-qty-btn btn btn-warning"
                                        data-action="{{ route('cart.updateQtyInCart') }}"
                                >Update quantity</button>
                            </td>
                            <td class="hidden-xs text-center"><strong>Total € {{ $cart->total_price }}</strong></td>
                            <td><button class="btn btn-success btn-block">Send order</button></td>
                        </tr>
                    </tfoot>
                </table>

            @else
                <div>There are no products in the cart. <a href="{{ route('homepage') }}">Check our products</a></div>
            @endif

        </div>
    </section>
@endsection

@section('script')
    <script src="js/cart.js"></script>
@endsection
