@extends('layouts.app')

@section('pagecss')
    <link href="{{ asset('css/welcome.css') }}" rel="stylesheet">
@endsection

@section('content')
    <section class="products">
        <div class="container">
            <a href="/product/create">Create product</a>
{{--            @if(isset($products))--}}
            <ul class="product-list">
                @foreach($products as $product)
                    <li class="product-list__item">
                        <div class="product">
{{--                            <a href="/product/{{$product->id}}" class="product__image">--}}
                            <a href="{{ $product->path() }}" class="product__image">
                                <img
                                    @if ($product->type === 'Phone' || $product->type === 'Balalaika')
                                        src="/img/{{$product->type}}.jpg"
                                    @else
                                        src="https://placehold.it/150x150"
                                    @endif
                                    alt="{{$product->reference}}">
                            </a>
                            <a href="{{ $product->path() }}" class="product__name">{{$product->reference}}</a>
                            <p class="product__short-text">{{$product->description_short}}</p>
                            <p class="product__price">{{$product->price}}</p>
                            <button class="btn-add-to-basket">Add to basket</button>
                        </div>
                    </li>
                @endforeach
            </ul>
{{--            @endif--}}
        </div>
    </section>
@endsection
