const loaderElem = document.querySelector('.loader');

function setAddToCardEventListener() {
    document.querySelector('.products').addEventListener('click', function(e) {
        if (!e.target.classList.contains('js-btn-add-to-basket')) return;

        const actionUrl = e.target.dataset.action;

        loaderElem.classList.toggle('loader-show');

        axios.post(actionUrl)
            .then(function (response) {
                const cartAmountElem = document.querySelector('.amount-in-cart');
                cartAmountElem.textContent = response.data;
                loaderElem.classList.toggle('loader-show');
                toastr.success('Product added to cart');
            })
            .catch(function (error) {
                console.log(error);
                loaderElem.classList.toggle('loader-show');
                toastr.error('Error, something went wrong');
            });
    });
}

setAddToCardEventListener();
