function setUpdateCartQtyEventListener() {
    document.querySelector('.js-update-qty-btn').addEventListener('click', function(e) {

        const actionUrl = this.dataset.action;

        const qtyInputs = document.querySelectorAll('.js-qty-input');

        const productsQty = {};

        qtyInputs.forEach(item => {
           const productId = item.dataset.product_id;
            productsQty[productId] = item.value;
        });

        axios.post(actionUrl, {
            productsQty: JSON.stringify(productsQty)
        })
            .then(function (response) {
                const redirectLinkWhenCartIsEmpty = response.data;
                if (redirectLinkWhenCartIsEmpty) {
                    window.location.replace(redirectLinkWhenCartIsEmpty);
                } else {
                    document.location.reload(true);
                }
            })
            .catch(function (error) {
                console.log(error);
            });
    });
}

function setRemoveItemEventListener() {
    document.querySelector('.js-products-in-cart').addEventListener('click', function(e) {
        if (!e.target.classList.contains('js-remove-btn')) return;
        const actionUrl = e.target.dataset.action;

        axios.post(actionUrl)
            .then(function (response) {
                const data = response.data;

                if ('totalQty' in data) {
                    document.querySelector('.amount-in-cart').textContent = data.totalQty;
                    e.target.closest('.js-product-row').remove();
                    toastr.success('Product deleted');
                } else {
                    window.location.replace(data.redirectLink);
                }
            })
            .catch(function (error) {
                console.log(error);
                toastr.error('Error, something went wrong');
            });
    });
}

setUpdateCartQtyEventListener();
setRemoveItemEventListener();
