@extends('layouts.profile')

@section('pagecss')
    <link rel="stylesheet" href="/css/profile/orders.css">
@endsection

@section('profile-content')
    @if ($orders->isEmpty())
        <p class="h3">You don't have any orders. <a href="{{ route('homepage') }}">Check our products</a></p>
    @else
        @foreach($orders as $order)
            <div class="card mb-3 order-card">
                <div class="card-header order-card-header d-flex"
                     data-toggle="collapse"
                     data-target="#{{ 'order_' . $order->id }}"
                >
                    <div style="width: 150px;">Order# {{ $order->id }}</div>
                    <div>{{ $order->created_at->format('jS F Y G:i') }}</div>
                    <div class="ml-auto">{{ $order->total_qty }} {{ ($order->total_qty === 1) ? 'item' : 'items' }}, total price {{ $order->total_price }} EUR</div>
                </div>
                <div class="collapse" id="{{ 'order_' . $order->id }}">
                    <ul class="list-group list-group-flush">
                        @foreach($order->products as $product)
                            <li class="list-group-item order-item">
                                <a href="{{ route('product.show', $product->product_id) }}"
{{--                                   href="{{ $product->product->path() }}" TODO ask if this is good for performance, to get product from eloquent relation --}}
                                >{{ $product->ordered_reference }}</a>
                                <div class="d-flex">
                                    <div>{{ $product->ordered_price }} EUR</div>
                                    <div class="ml-auto">{{ $product->ordered_qty }} {{ ($product->ordered_qty === 1) ? 'pc' : 'pcs' }}</div>
                                    <div class="subtotal-price">{{ $product->subtotal_price }} EUR</div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endforeach
        {{ $orders->links() }}
    @endif
@endsection
