function setAddToCardEventListener() {
    document.querySelector('.products').addEventListener('click', function(e) {
        if (!e.target.classList.contains('js-btn-add-to-basket')) return;

        const actionUrl = e.target.dataset.action;

        axios.post(actionUrl)
            .then(function (response) {
                const cartAmountElem = document.querySelector('.amount-in-cart');
                cartAmountElem.textContent = response.data;
            })
            .catch(function (error) {
                console.log(error);
                alert('Sorry, error, we are just learning how to code');
            });
    });
}

setAddToCardEventListener();
