@extends('layouts.app')

@section('pagecss')
    <link href="{{ asset('css/welcome.css') }}" rel="stylesheet">
@endsection

@section('content')
    <section class="products">
        <div class="container">
            <a href="/product/create">Create product</a>

            <ul class="product-list">
                @foreach($products as $product)
                    <li class="product-list__item">
                        <div class="product">
{{--                            <a href="/product/{{$product->id}}" class="product__image">--}}
                            <a href="{{ $product->path() }}" class="product__image">
                                <img src="/img/{{$product->type}}.jpg" alt="{{$product->reference}}">
                            </a>
                            <a href="{{ $product->path() }}" class="product__name">{{$product->reference}}</a>
                            <p class="product__short-text">{{$product->description_short}}</p>
                            <p class="product__price">{{$product->price}} EUR</p>

                            <button class="btn-add-to-basket btn btn-info"
                                    data-product_id="{{ $product->id }}"
                                    data-action="{{ route('product.addToCart', $product) }}"
                            >Add to basket</button>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>
    </section>
@endsection

@section('script')
    <script src="js/welcome.js"></script>
@endsection
