<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/', 'ProductController@index')->name('homepage');

Route::prefix('product')->group(function() {
    Route::post('/', 'ProductController@store');
    Route::get('/create', 'ProductController@create');
    Route::get('/{product}', 'ProductController@show')->name('product.show');
    Route::get('/{product}/edit', 'ProductController@edit')->name('product.edit');
    Route::put('/{product}', 'ProductController@update');
//    Route::delete('/{product}', 'ProductController@destroy');
});

Route::prefix('cart')->group(function() {
    Route::get('/', 'CartController@index')->name('cart.index');
    Route::post('/add/{product}', 'CartController@addToCart')->name('cart.addToCart');
    Route::post('/update', 'CartController@updateQtyInCart')->name('cart.updateQtyInCart');
    Route::post('/remove/{product}', 'CartController@removeFromCart')->name('cart.removeFromCart');
    Route::post('/clear', 'CartController@clearCart')->name('cart.clearCart');
});

Route::middleware('auth')->prefix('profile')->group(function() {
    Route::get('/', 'ProfileController@index')->name('profile');
    Route::get('/personal', 'ProfileController@index')->name('profile.index');
    Route::get('/orders', 'ProfileController@showOrders')->name('profile.orders');
    Route::get('/export-products', 'ProfileController@exportIndex')->name('profile.export-products-view');
    Route::post('/export-products', 'ProductController@export')->name('export-products');
});

Route::redirect('order', '/'); // TODO to ask if there is a way to show 404 and not use redirect
Route::post('order', 'OrderController@store')->name('order.sendOrder')->middleware('auth');
