<?php

namespace App\Http\Controllers;

use App\Product;
use Illuminate\Http\Request;
//use DB;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
//        $products = DB::table('products')->get();
        $products = Product::get();

        return view('welcome', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('product.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(/*Request $request*/)
    {
        request()->validate([
            'reference' => 'required',
            'description_short' => 'required',
            'description_long' => 'required',
            'price' => 'required',
            'type' => 'required'
        ]);

        $product = new Product();
        $product->reference = request('reference');
        $product->description_short = request('description_short');
        $product->description_long = request('description_long');
        $product->price = request('price');
        $product->type = request('type');
        $product->save();

        return redirect('/');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
//        $product = DB::table('products')->where('id', $product)->first();
//        $product = Product::where('id', $product)->firstOrFail();
//        $product = Product::findOrFail($product);

//        return view('product', [
//            'product' => $product
//        ]);

        return view('product.product', compact('product'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $product)
    {
//        $product = Product::findOrFail($product);

        return view('product.edit', compact('product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(/*Request $request, Product $product*/ $product)
    {
        request()->validate([
            'reference' => 'required',
            'description_short' => 'required',
            'description_long' => 'required',
            'price' => 'required',
            'type' => 'required'
        ]);

        $product = Product::find($product);
        $product->reference = request('reference');
        $product->description_short = request('description_short');
        $product->description_long = request('description_long');
        $product->price = request('price');
        $product->type = request('type');
        $product->save();

        return redirect("/product/{$product->id}");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        //
    }
}
