@extends('layouts.profile')

@section('pagecss')
    <link rel="stylesheet" href="/css/profile/orders.css">
@endsection

@section('profile-content')
    @if ($orders->isEmpty())
        <p class="h3">You don't have any orders. <a href="{{ route('homepage') }}">Check our products</a></p>
    @else
        @foreach($orders as $order)
            <div class="card mb-3 order-card">
                <div class="card-header order-card-header d-flex"
                     data-toggle="collapse"
                     data-target="#{{ 'order_' . $order->id }}"
                >
                    <div class="mr-5">Order# {{ $order->id }}</div>
                    <div>{{ $order->created_at->format('jS F Y G:i') }}</div>
                    <div class="ml-auto">{{ $order->total_qty }} {{ ($order->total_qty === 1) ? 'item' : 'items' }}, total price {{ $order->total_price }} EUR</div>
                </div>
                <div class="collapse" id="{{ 'order_' . $order->id }}">
                    @foreach($order->products as $product)
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">
                                <a href="{{ $product->product->path() }}">{{ $product->ordered_reference }}</a>
                                <div class="d-flex">
                                    <div>{{ $product->ordered_price }} EUR</div>
                                    <div class="ml-auto">{{ $product->ordered_qty }} {{ ($product->ordered_qty === 1) ? 'pc' : 'pcs' }}</div>
                                    <div class="subtotal-price">{{ $product->subtotal_price }} EUR</div>
                                </div>
                            </li>
                        </ul>
                    @endforeach
                </div>
            </div>
        @endforeach
    @endif
@endsection
