@extends('layouts.app')

@section('content')
    <section class="create-product">
        <div class="container">
            <h1>Update product</h1>
            <form method="POST" action="{{ $product->path() }}">
                @csrf
                @method('PUT')

                <div class="form-group row">
                    <label for="reference" class="col-sm-2 col-form-label">Product reference</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="reference" name="reference" value="{{ $product->reference }}" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="description_short" class="col-sm-2 col-form-label">Short description</label>
                    <div class="col-sm-10">
                        <textarea class="form-control" id="description_short" rows="3" name="description_short" required>{{ $product->description_short }}</textarea>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="description_long" class="col-sm-2 col-form-label">Long description</label>
                    <div class="col-sm-10">
                        <textarea class="form-control" id="description_long" rows="3" name="description_long" required>{{ $product->description_long }}</textarea>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="type" class="col-sm-2 col-form-label">Product type</label>
                    <div class="col-sm-10">
                        <select class="custom-select custom-select" name="type" id="type" required>
                            <option value="Phone"
                                    {{ ($product->type === 'Phone') ? 'selected' : '' }}
                            >Phone</option>
                            <option value="Balalaika"
                                    {{ ($product->type === 'Balalaika') ? 'selected' : '' }}
                            >Balalaika</option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="price" class="col-sm-2 col-form-label">Price</label>
                    <div class="col-sm-10">
                        <input type="number" class="form-control" id="price" name="price" value="{{ $product->price }}" required>
                    </div>
                </div>
                <button class="btn btn-primary">Submit</button>
            </form>
        </div>
    </section>
@endsection
