<?php

namespace App;

use App\Product;

class Cart
{
    public function __construct()
    {
        $this->items = [];
        $this->total_qty = 0;
        $this->total_price = 0;
    }

    public function updateTotalPosAmount()
    {
        $this->total_qty = count($this->items);
    }

    public function updatePrices()
    {
        $total_price = 0;
        foreach ($this->items as $id => $item)
        {
            $subtotal_price = $item['qty'] * $item['item']->price;
            $this->items[$id]['subtotal_price'] = $subtotal_price;
            $total_price += $subtotal_price;
        }
        $this->total_price = $total_price;
    }

    public function addItem($id)
    {
        if (array_key_exists($id, $this->items)) {
            $this->items[$id]['qty']++;
        } else {
            $this->items[$id] = [
                'qty' => 1
            ];
        }

        $this->updateTotalPosAmount();
    }

    public function updateQty($product_id, $changed_qty)
    {
        $changed_qty = abs($changed_qty);

        if (array_key_exists($product_id, $this->items)) {
            if ($changed_qty === 0) {
                $this->items[$product_id]['qty'] = 1;
            } else {
                $this->items[$product_id]['qty'] = $changed_qty;
            }
        } else {
            $this->addItem($product_id);
            $this->items[$product_id]['qty'] = $changed_qty;
        }
    }

    public function removeItem($id)
    {
        unset($this->items[$id]);
        $this->updateTotalPosAmount();
    }

    public function updateCurrentItems()
    {
//        foreach ($this->items as $id => $item) {
//            $this->items[$id]['item'] = Product::where('id', $id)->first();
//        }
// TODO ask if this is good solution for perfromance improvement
        $productsIdArr = [];
        foreach ($this->items as $id => $item) {
            $productsIdArr[] = $id;
        }
        $products = Product::whereIn('id', $productsIdArr)->get();

        foreach ($products as $product) {
            $this->items[$product->id]['item'] = $product;
        }

        $this->updatePrices();
    }
}
