<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    public function index()
    {
        return view('profile.personal');
    }

    public function showOrders()
    {
        $orders = Auth::user()->orders()
                                ->with('products') // TODO ask if this is correct use
                                ->orderBy('id', 'desc')
                                ->paginate(10);

        return view('profile.orders', compact('orders'));
    }

    public function exportIndex()
    {
        return view('profile.export-products');
    }
}
