<?php

namespace App\Http\Controllers;

use App\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Session;

class OrderController extends Controller
{
    function store()
    {
        if (!Session::has('cart')) {
            return redirect('cart');
        }

        $cart = Session::get('cart');

        $order = Order::create([
            'user_id' => Auth::id(),
            'total_price' => $cart->total_price,
            'total_qty' => $cart->total_qty,
        ]);

        $order_id = $order->id;

        Session::forget('cart');

        return view('cart', compact('order_id'));
    }
}
